<?php
//VERSION 0


function RecalculeMontantRestantDuLocation($idEcole,$idClient,$idLocation,$paramDTF){
	$infoLocation=GetInfoLocationsVendues($idEcole,$idClient,$idLocation);
	$linkIdFactureGroupee=$infoLocation[0]['idFactureGroupee'];
	if($linkIdFactureGroupee!=-1){
		UpdateRestantDuFactureGroupee($idEcole,$linkIdFactureGroupee,$infoLocation[0]['isDevis'],$paramDTF);
	}
	else{
		$totalDejaPaye=0;
		$paiements=GetPaimentLocation($idEcole,$idLocation);
		foreach($paiements as $paiement){
			$totalDejaPaye+=$paiement['montant'];
		}
		$prixTotalLocation=GetPrixTotalLocation($idEcole,$idClient,$idLocation);
		$prixFormule=$prixTotalLocation['totalApresRemise']-$totalDejaPaye;
		$nouveauRestantDu=round($prixFormule*100)/100;
		$modif=ModifyRestantDuLocationBD($idEcole,$idLocation,$nouveauRestantDu,$prixTotalLocation['total'],$prixTotalLocation['totalApresRemise'],$prixTotalLocation['montantDeLaRemise']);
		$descriptifArticle=$prixTotalLocation['displayDureeRetenueDTF'];
		$descriptifArticle.=GetDisplayDatesForDtf($infoLocation[0]['dateHeureDebut'],$infoLocation[0]['dateHeureFin']);
		$nbLocation=count($infoLocation[0]['dateHeureDebut']);
		$nbLocationDisplay=$nbLocation==1?"location":$nbLocation." locations";
		$paramDTF=AddupDTFParameters($paramDTF,$infoLocation[0]['tauxTVA'],$nbLocationDisplay.": ".$infoLocation[0]['nomType'],$descriptifArticle,$prixTotalLocation['total'],$prixTotalLocation['totalApresRemise'],$prixTotalLocation['montantDeLaRemise'],$prixTotalLocation['displayDTF'],$paiements,$nouveauRestantDu,"location","");
		AddDTF($idEcole,"location",$idLocation,$infoLocation[0]['isDevis'],$paramDTF);
	}
}
function GetDisplayDatesForDtf($dateHeureDebut,$dateHeureFin){
	$ret="";
	$dateDebut="9999-99-99";
	$dateFin="0000-00-00";
	$indiceLoc=0;
	foreach($dateHeureDebut as $deb){
		if($dateHeureDebut[$indiceLoc]!="---"){
			$ddTemp=RenverseDate(substr($dateHeureDebut[$indiceLoc],9));//Transforme la date de jj/mm/aaa en aaaa-mm-jj
			$dateDebut=$ddTemp<$dateDebut?$ddTemp:$dateDebut;
			$dfTemp=RenverseDate(substr($dateHeureFin[$indiceLoc],9));//Transforme la date de jj/mm/aaa en aaaa-mm-jj
			$dateFin=$dfTemp>$dateFin?$dfTemp:$dateFin;
		}
		$indiceLoc++;
	}
	if($dateDebut!="9999-99-99" and $dateDebut==$dateFin){
		$ret=" (le ".ReRenverseDate($dateDebut).")";
	}
	elseif($dateDebut!="9999-99-99"){
		$ret=" (du ".ReRenverseDate($dateDebut)." au ".ReRenverseDate($dateFin).")";
	}
	return $ret;
}
function GetInfoLocationsVendues($idEcole,$idClient,$idLocation){
	$infos=GetInfoLocationsVenduesBD($idEcole,$idClient,$idLocation);
	$ret=Array();
	$cpt=-1;
	$idLocationCourante=-1;
//Boucle pour compacter le resultat
	foreach($infos as $info){
		if($idLocationCourante!=$info['idLocation']){
			$cpt++;
			$idLocationCourante=$info['idLocation'];
			$cptIndiceLocationProduit=0;
			$ret[$cpt]['idLocation']=$info['idLocation'];
			$ret[$cpt]['nomType']=$info['nomType'];
			$ret[$cpt]['lesFamillesDuType']=$info['lesFamillesDuType'];
			$ret[$cpt]['duree']=$info['duree'];
			$ret[$cpt]['prix']=$info['prix'];
			$ret[$cpt]['prixLibreTotal']=$info['prixLibreTotal'];
			$ret[$cpt]['restantDu']=$info['restantDu'];
			$ret[$cpt]['discount']=$info['discount'];
			$ret[$cpt]['idFormule']=$info['idFormule'];
			$ret[$cpt]['idFactureGroupee']=$info['idFactureGroupee'];
			$ret[$cpt]['idLocationSpot']=$info['idLocationSpot'];
			$ret[$cpt]['nomLocationSpot']=GetLocationSpotDisplay($idEcole,$info['idLocationSpot']);
			$ret[$cpt]['isDevis']=$info['isDevis'];
			$ret[$cpt]['tauxTVA']=$info['tauxTVA'];
			$ret[$cpt]['montant']=$info['montant'];

			$ret[$cpt]['dateCreation']="créé à ".RenverseDateDifferentEncore($info['dateCreation']);
			$ret[$cpt]['dateCreationBrute']=$info['dateCreation'];
			$ret[$cpt]['dateHeureDebut'][$cptIndiceLocationProduit]=RenverseDateDifferentEncore($info['dateHeureDebut']);
			$ret[$cpt]['dateHeureFin'][$cptIndiceLocationProduit]=RenverseDateDifferentEncore($info['dateHeureFin']);
			$ret[$cpt]['dateHeureDebutBrute'][$cptIndiceLocationProduit]=$info['dateHeureDebut'];
			$ret[$cpt]['dateHeureFinBrute'][$cptIndiceLocationProduit]=$info['dateHeureFin'];
			$ret[$cpt]['idLocationFamille'][$cptIndiceLocationProduit]=$info['idLocationFamille'];
			$ret[$cpt]['gestionPlanningLocation'][$cptIndiceLocationProduit]=$info['gestionPlanningLocation'];
			$ret[$cpt]['nomFamille'][$cptIndiceLocationProduit]=$info['nomFamille'];
			$ret[$cpt]['dureeDefaut'][$cptIndiceLocationProduit]=$info['dureeDefaut'];
			$ret[$cpt]['idLocationProduit'][$cptIndiceLocationProduit]=$info['idLocationProduit'];
			$ret[$cpt]['nomProduit'][$cptIndiceLocationProduit]=$info['nomProduit'];
			$ret[$cpt]['taille'][$cptIndiceLocationProduit]=$info['taille'];
			$ret[$cpt]['idLocationPeriode'][$cptIndiceLocationProduit]=$info['idLocationPeriode'];
		}
		else{
			$cptIndiceLocationProduit++;
			$ret[$cpt]['dateHeureDebut'][$cptIndiceLocationProduit]=RenverseDateDifferentEncore($info['dateHeureDebut']);
			$ret[$cpt]['dateHeureFin'][$cptIndiceLocationProduit]=RenverseDateDifferentEncore($info['dateHeureFin']);
			$ret[$cpt]['dateHeureDebutBrute'][$cptIndiceLocationProduit]=$info['dateHeureDebut'];
			$ret[$cpt]['dateHeureFinBrute'][$cptIndiceLocationProduit]=$info['dateHeureFin'];
			$ret[$cpt]['idLocationFamille'][$cptIndiceLocationProduit]=$info['idLocationFamille'];
			$ret[$cpt]['nomFamille'][$cptIndiceLocationProduit]=$info['nomFamille'];
			$ret[$cpt]['dureeDefaut'][$cptIndiceLocationProduit]=$info['dureeDefaut'];
			$ret[$cpt]['idLocationProduit'][$cptIndiceLocationProduit]=$info['idLocationProduit'];
			$ret[$cpt]['gestionPlanningLocation'][$cptIndiceLocationProduit]=$info['gestionPlanningLocation'];
			$ret[$cpt]['nomProduit'][$cptIndiceLocationProduit]=$info['nomProduit'];
			$ret[$cpt]['taille'][$cptIndiceLocationProduit]=$info['taille'];
			$ret[$cpt]['idLocationPeriode'][$cptIndiceLocationProduit]=$info['idLocationPeriode'];
		}
		if($ret[$cpt]['dateHeureDebut'][$cptIndiceLocationProduit]=="00:00 le 00/00/0000"){
			$ret[$cpt]['dateHeureDebut'][$cptIndiceLocationProduit]="---";
		}
		if($ret[$cpt]['dateHeureFin'][$cptIndiceLocationProduit]=="00:00 le 00/00/0000"){
			$ret[$cpt]['dateHeureFin'][$cptIndiceLocationProduit]="---";
		}
		if($ret[$cpt]['nomProduit'][$cptIndiceLocationProduit]==""){
			$ret[$cpt]['nomProduit'][$cptIndiceLocationProduit]="";
		}
	}
	return $ret;
}
function GetPaimentLocation($idEcole,$idLocation){
	$ret=GetPaimentLocationBD($idEcole,$idLocation);
	return $ret;
}
function GetPrixTotalLocation($idEcole,$idClient,$idLocation){
//	$infoLocation=GetInfoLocationBD($idEcole,$idLocation);
	$infoLocations=GetInfoLocationsVendues($idEcole,$idClient,$idLocation);
	$infoLocation=$infoLocations[0];
	$discount=$infoLocation['discount'];
	$prixLibreTotal=$infoLocation['prixLibreTotal'];
	$displayDureeRetenue="";
	$displayDureeRetenueDTF="";
	$prixLocation=0;
	if($prixLibreTotal!=-1){
		$prixLocation=$prixLibreTotal;
	}
	else{
		//On regarde toutes les durees des locations, et on garde la plus longue.
		$dureeMax=0;
		$prixLocation=0;
		for($i=0;$i<count($infoLocation['dateHeureDebut']);$i++){
			$dateDeb=$infoLocation['dateHeureDebut'][$i];
			$dateFin=$infoLocation['dateHeureFin'][$i];
			if($dateDeb!="---"){
				$dureeCourante=DureeEntreDeuxDatesHeures($dateDeb,$dateFin);
				$dureeMax=$dureeMax<$dureeCourante?$dureeCourante:$dureeMax;
			}
		}
		if($dureeMax==0){
		//On pioche dans la bonne tranche pour le tarif
			$prixLocation=0;
		}
		else{
			$displayDureeRetenue="durée retenue: <b>";
			$displayDureeRetenueDTF="durée retenue: ";
			$prixs=GetValuesFromComaList($infoLocation['prix'],";");
			$durees=GetValuesFromComaList($infoLocation['duree'],";");

			$dureeSpecifieeMax=substr($durees[count($durees)-1],0,-1);//Pour enlever le "h"
			if($dureeMax>$dureeSpecifieeMax){//Si la duree est suppérieure à la derniere durée spécifiée, on va chercher le multiple
				$CombienDeDureesMax=((int)($dureeMax/$dureeSpecifieeMax))+1;
				$prixSpecifieeMax=$prixs[count($prixs)-1];
				$prixLocation=$CombienDeDureesMax*$prixSpecifieeMax;
				$temp=($CombienDeDureesMax*$dureeSpecifieeMax)/24;
				$displayDureeRetenue.=$temp;
				$displayDureeRetenue.=$temp==1?" jour":" jours";
				$displayDureeRetenueDTF.=$temp;
				$displayDureeRetenueDTF.=$temp==1?" jour":" jours";

				
			}
			else{
				for($i=0;$i<count($durees);$i++){
					if($dureeMax<=substr($durees[$i],0,-1)){//Pour enlever le "h"
						$prixLocation=$prixs[$i];
						$displayDureeRetenue.=$durees[$i];
						$dureeTemp=substr($durees[$i],0,-1);
						if($dureeTemp>47){
							$displayDureeRetenueDTF.=($dureeTemp/24)." jours";
						}
						elseif($dureeTemp>23){
							$displayDureeRetenueDTF.=($dureeTemp/24)." jour";
						}
						else{
							$displayDureeRetenueDTF.=$durees[$i];
						}
						break;
					}
				}
			}
			$displayDureeRetenue.="</b>";
			//Combien de locations a ton vendues?
			//Et oui, j'ai pas voulu stocker ca en base, alors on calcule...
			$lesFamillesDuType=count(GetValuesFromComaList($infoLocation['lesFamillesDuType'],";"));
			$nbProduitsRattaches=count($infoLocation['dateHeureDebut']);
			$nbLocVendues=$nbProduitsRattaches/$lesFamillesDuType;
			$prixLocation=$prixLocation*$nbLocVendues;
		}
	}
	$ret['display']="<b>".$prixLocation."€</b>";
	$ret['total']=$prixLocation;
	$ret['montantDeLaRemise']=0;
	$ret['displayMontantDeLaRemise']="";
	$ret['displayDTF']=0;
	if($discount>0){
		$prixAjusteApresRemise=AjustePrixApresRemise($prixLocation,$discount);
//Putain de blague!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//https://stackoverflow.com/questions/17210787/php-float-calculation-error-when-subtracting
//		$ret['montantDeLaRemise']=$prixLocation-$prixAjusteApresRemise['montantApresRemise'];
		$ret['montantDeLaRemise']=(floor($prixLocation*100)-floor($prixAjusteApresRemise['montantApresRemise']*100))/100;
		$ret['displayMontantDeLaRemise']=$prixAjusteApresRemise['displayMontantDeLaRemise'];
		$prixLocation=$prixAjusteApresRemise['montantApresRemise'];
		$ret['display'].="-".$prixAjusteApresRemise['displayMontantDeLaRemise']." = ".$prixLocation."€";
		$ret['displayDTF']=$prixAjusteApresRemise['displayMontantDeLaRemise'];
	}
	if($displayDureeRetenue!=""){
		$ret['display'].="</br>".$displayDureeRetenue;
	}
	$ret['totalApresRemise']=round($prixLocation*100)/100;
	$ret['displayDureeRetenueDTF']=$displayDureeRetenueDTF;
	return $ret;
}

// hash: c767c1ac477ad9196e775bfef39226e79d0f2acc9854ed7715c447c225e84e32
?>
